<?php
/** 
 * Módulo Gerencianet por Mauricio Gofas (gofas.net)
 * @copyright Copyright (c) gofas.net 2016
 * @see https://gofas.net
*/
if (!defined("WHMCS")) die("This file cannot be accessed directly");

require __DIR__ . '/../../gateways/gofasgerencianetboleto/sdk/vendor/autoload.php';
use Gerencianet\Exception\GerencianetException;
use Gerencianet\Gerencianet;

// Reporta todos os erros
error_reporting(E_ERROR | E_WARNING | E_PARSE);

function gofasgerencianet_config() {
	
    $configarray = array(
    "name" => "Gofas Gerencianet Dashboard",
    "description" => "Painel de gerenciamento remoto da API Gerencianet.",
    "version" => '1.2',
    "author" => "<a href='https://gofas.net' target='_blank'>Gofas</a>",
    "fields" => array(
        // Client ID
		'clientid' => array(
			'FriendlyName' => 'Client_Id Produção',
			'Type' => 'text',
			'Size' => '60',
			'Default' => '',
			'Description' => 'Necessário',
		),
		// Client Secret
		'clientsecret' => array(
			'FriendlyName' => 'Client_Secret Produção',
			'Type' => 'text',
			'Size' => '60',
			'Default' => '',
			'Description' => 'Necessário',
		),
		// Client ID Sandbox
		'clientidsandbox' => array(
			'FriendlyName' => 'Client_Id Desenvolvimento',
			'Type' => 'text',
			'Size' => '60',
			'Default' => '',
			'Description' => 'Opcional',
		),
		// Client Secret Sandbox
		'clientsecretsandbox' => array(
			'FriendlyName' => 'Client_Secret Desenvolvimento',
			'Type' => 'text',
			'Size' => '60',
			'Default' => '',
			'Description' => 'Opcional',
		),
		// Testar?
		'testmode' => array(
			'FriendlyName' => 'Sandbox',
			'Type' => 'yesno',
			'Description' => 'Marque essa opção se você estiver utilizando o par de chaves "Client_Id" e "Client_Secret" do modo Desenvolvimento da <a style="text-decoration: underline;" href="https://docs.gerencianet.com.br/minhas-aplicacoes/" target="_blank">sua aplicação</a>.',
		),
		// Debug?
		'debugmode' => array(
			'FriendlyName' => 'Debug',
			'Type' => 'yesno',
			'Description' => 'Marque essa opção para exibir resultados e erros retornados pela API Gerencianet e API interna do WHMCS.<b><br/>Use isso apenas em modo de testes ou se precisar diagnosticar erros.',
		),
		// whmcs admin
		'admin' => array(
			'FriendlyName' => 'Administrador atribuído',
			'Type' => 'text',
			'Size' => '25',
			'Default' => '',
			'Description' => 'Insira o nome de usuário ou ID do administrador que será atribuído as transações. Necessário para usar a API interna do WHMCS.',
		),
		// Crédito
		'credits' => array(
			'Description' => '<div style="background: #dde9f9;padding: 5px 15px;position: absolute; bottom: 0;">Versão 1.0 | <a target="_blank" title="↗ Gofas.net" href="https://gofas.net">&copy; '.date('Y').' Gofas.net</a> | <a target="_blank" title="↗ Documentação e Suporte" href="https://github.com/gofas/whmcs-gerencianet-dashboard/">Documentação e Suporte</a><br/></div>',
		),
							  
    ));
    return $configarray;
}

function gofasgerencianet_output($vars) {
 
    //$modulelink	= $vars['modulelink'];
	$version	= $vars['version'];
	$debug		= $vars['debugmode'];
	$sandbox	= $vars['testmode'];
	$whmcsAdmin	= $vars['admin'];
	if ($_SERVER['HTTPS']) { $http = 'https://'; } else { $http = 'http://';}
	$domain		= $_SERVER['SERVER_NAME'];
	$moduleSlug = $_SERVER['REQUEST_URI'];
	$moduleURL	= $http.$domain.$moduleSlug;
	
	if ($sandbox) { $clientid = $vars['clientidsandbox']; $clientsecret	= $vars['clientsecretsandbox'];
	} elseif (!$sandbox) { $clientid		= $vars['clientid']; $clientsecret	= $vars['clientsecret'];}
	$options = ["client_id"=>$clientid,"client_secret"=>$clientsecret,"sandbox"=>$sandbox,"debug"=>$debug]; $api = new Gerencianet($options);
	
if ( $_POST['invoice_id'] || $_POST['trans_id'] ) {
		
	// Verifica transações associadas à fatura
	if ( $_POST['invoice_id'] ) {
		
		$invoice_id	= $_POST['invoice_id'];
			
		// Parâmetros da fatura
		$getinvoice					= 'getinvoice';
		$getinvoice_id['invoiceid']	= $invoice_id;
		$getinvoiceResults			= localAPI($getinvoice,$getinvoice_id,$whmcsAdmin);
	
		// Parâmetros das transações
		$transIDendA					= $getinvoiceResults['transactions'];
		if($transIDendA) {
			$transIDend						= $transIDendA['transaction'];
		}
		if ($transIDend) {
			$transIDp					= end($transIDend); // Pula para o último resultado do array
			$transID					= $transIDp['transid']; // Captura ID da Última transação
			$charge 					= $transID;
		} else {
			$transID					= false;
			$error					.= 'Nenhuma transação que possa ser cancelada foi encontrada para a fatura #'.$invoice_id .' ou essa fatura não existe.';
		}

	} elseif ( $_POST['trans_id'] ) {
		$trans_id = $_POST['trans_id'];
		$charge = $trans_id;
		
	}
	
	// Verifica se a fatura possui um boleto associado
	if ( $charge ) {
	
		// Verifica se a fatura atual já tem um boleto associado
		try {
			$chargeExist = $api->detailCharge(['id' => (int)$charge ],[]);
			$chargeExistID = $chargeExist['data']['charge_id'];// Captura id da transação gerada anteriormente pela fatura atual		
			$chargeExistStatus = $chargeExist['data']['status'];
		
        	if ($debug) {
            	echo '<pre><b>Resultado da busca pela transação  #'.$charge.'.</b><br/>';
				echo'Essa fatura já gerou um boleto.<br/>';
				print_r($chargeExist);
				echo '<br/>';
				echo $chargeExistStatus;
				echo'<br/></pre>';
        	}
			//$result .= 'Boleto localizado<br/>';
		
    	} catch (GerencianetException $e) {
			if ($debug) {
				echo '<pre><b>Resultado da busca por boletos gerados pela fatura #'.$invoice_id.'.</b><br/>';
            	if ($e->code == '3500034') {
					echo'<b>Essa fatura ainda não gerou nenhum boleto.</b><br/>';
				} else {
				    echo'<b>Erro ao consultar boletos gerados por essa fatura.</b><br/>';
				}
				print_r($e->code);
				echo '<br/>';
				print_r($e->error);
				echo '<br/>';
				print_r($e->errorDescription);
				echo '<br/>';
				echo'<br/></pre>';
			}
			
			$error .= $e->errorDescription['message'].'<br/>';
			
		} catch (Exception $e) {
			if ($debug) {
				echo'<pre><b>Erro de comunicação (API externa - Gerencianet).</b><br/>';
				print_r($e->getMessage());
				echo'<br/></pre>';
			}
			$error .= $e->getMessage().'<br/>';
			
		}
	}
	
	// Cancela
	if ( !$error and $chargeExistStatus !== 'paid' and $chargeExistStatus !== 'canceled' ) {
		try {
                $api = new Gerencianet($options);
                $cancelCharge = $api->cancelCharge(['id' => (int)$charge ], []);
				
				if ( $cancelCharge['code'] == '200' ) {
					$result .= 'Transação cancelada.';
					
				} else {
					$error				.= 'Transação não cancelada.';
					
				}
				
                if ($debug) {
                    echo '<pre><b>Transação ' . $transID . ' cancelada com sucesso.</b><br/>';
                    print_r($cancelCharge);
					echo '<br/>';
					//echo $cancelCharge['code'];
                    echo '</pre>';
				}
				
            } catch (GerencianetException $e) {
                if ($debug) {
                    echo '<pre><b>Erro ao cancelar transação #' . $charge . '</b><br/>';
                    echo '<br/>';
                    print_r($e->code);
                    echo '<br/>';
                    print_r($e->error);
                    echo '<br/>';
                    print_r($e->errorDescription);
                    echo '<br/></pre>';
                }
				
				$error .= $e->errorDescription['message'];
				
            } catch (Exception $e) {
                if ($debug) {
                    echo '<pre><b>Erro ao cancelar transação' . $charge . '</b><br/>';
                    print_r($e->getMessage());
                    echo '<br/></pre>';
                }
				
				$error .= $e->getMessage();
            }
		}
		// Pago
		elseif ( !$error and $chargeExistStatus == 'paid') {
			$error .= 'A transação #'.$charge.' não pode ser cancelapa pois já foi paga.';
			
		}
		// já cancelada
		elseif ( !$error and $chargeExistStatus == 'canceled') {
			$error .= 'A transação #'.$charge.' já foi cancelada.';
			
		}
		// Não encontrado
		elseif( !$error and $charge and !$chargeExistStatus ) {
			$error .= 'A API não retornou o status da transação, verifique as configurações do módulo e su painel da API Gerencianet.';
		}
	
	// Resultado
	if ($error || $chargeNoCanceled) {
		echo '<pre style="background:red; color: #fff;">';
		echo $error;
		echo '</pre>';
	} elseif ($result) {
		echo '<pre style="background: green;color: #fff;">';
		echo $result . $chargeNoCanceled;
		echo '</pre>';
	}
}
	// Admin form
	echo '<h3>Cancelar Boletos associados às Faturas</h3>';
	echo '<p style="margin-bottom:20px;border-bottom: 1px solid #dde9f9; padding-bottom: 10px;">Cancele transações na API Gerenciante através do ID da <b>Fatura</b> ou ID do <b>Boleto / Transação</b>.</p>';
	echo '	<form style="margin:0px 0px 25px 0px;min-height: 130px;border-bottom: 1px solid #dde9f9;" name="cancel_billet" method="POST" action="'.$moduleURL.'" >
    			<div style="margin-bottom:15px;">
					<span>Cancelar Transação através do ID da <b>Fatura</b></span>
					<input type="text" name="invoice_id">
		    		<input type="submit" value="Cancelar Transação">
				</div>
				<div>
					<span>Cancelar Transação através do ID da <b>Transação</b>
					<input type="text" name="trans_id">
		    		<input type="submit" value="Cancelar Transação">
				</div>
			</form>';
	echo '<div style="background: #dde9f9;padding: 5px 15px;">Versão '.$version.' | <a target="_blank" title="↗ Gofas.net" href="https://gofas.net">&copy; '.date('Y').' Gofas.net</a> | <a target="_blank" title="↗ Documentação e Suporte" href="https://github.com/gofas/whmcs-gerencianet-dashboard/">Documentação e Suporte</a><br/></div>';
}

?>
