<?php
/**
 * Módulo Gerencinet Boleto para WHMCS
 * @author		Mauricio Gofas | gofas.net
 * @see			https://gofas.net/?p=7893
 * @copyright	2017 https://gofas.net
 * @license		https://www.gnu.org/licenses/gpl-3.0.pt-br.html
 * @support		https://gofas.net/?p=7856
 * @version		1.0.1
 */
 
// Reporta todos os erros
error_reporting( E_ERROR | E_WARNING | E_PARSE );

if(!defined('WHMCS')) { die('Esse arquivo não pode ser acessado diretamente'); }


/**
 *
 * Consultar informações da transação
 * @ggnb_detail_charge
 *
 */

function ggnb_detail_charge( $API, $TRANSID, $DEBUG ){
	// Verifica se a fatura atual já tem um boleto associado
	try {
		$chargeExist = $API->detailCharge(['id' => (int)$TRANSID ],[]);
		$chargeExistStatus = $chargeExist['data']['status'];
		
        if ($DEBUG) {		
            echo '<pre class="debug"><p class="ok">Boletos gerados por esta fatura - API Gerencianet.</p>';
			echo'Essa fatura já gerou um boleto.<br/>';
			print_r($chargeExist);
			echo '<br/>';
			echo 'status: '.$chargeExistStatus;
			echo'<br/></pre>';
        }
    } catch (GerencianetException $e) {
		if ($DEBUG) {
            echo '<pre class="debug"><p class="ok">Resultado da busca por boletos gerados por esta fatura - API Gerencianet.</p>';
            if ($e->code == '3500034') {
				    echo'<p>Essa fatura ainda não gerou nenhum boleto.</p>';
				} else {
				    echo'<p>Não encontramos boletos gerados por essa fatura.</p>';
				}
				print_r($e->code);
				print_r($e->error);
				print_r($e->errorDescription);
			echo'<br/></pre>';
			}
		} catch (Exception $e) {
			if ($DEBUG) {
				if ($e->code == '3500034') {
				    echo'<pre class="debug"><p class="ok">Essa fatura ainda não gerou nenhum boleto.</p>';
					echo 'Erro '.$e->code.': '.$e->getMessage();
					
				} else {
				    echo'<pre class="debug"><p class="erro">Erro '.$e->code.' - API Gerencianet</p>';
					echo 'Erro '.$e->code.': '.$e->getMessage();
					
				}
				
				print_r($e->getMessage());
				echo'<br/></pre>';
			}
		}
		if ($chargeExist) {
			return $chargeExist;
		} else {
			return $error;
		}
		
}

/**
 *
 * Cancelar transação
 * ggnb_cancel_charge
 *
 */
function ggnb_cancel_charge( $API, $CHARGEEXISTID, $DEBUG ) {
	try {
				$ID = ['id' => (int)$CHARGEEXISTID];
				
                $cancelCharge = $API->cancelCharge( $ID, [] );
				
                if ($DEBUG) {
                    echo '<pre class="debug"><p class="ok">Transação anterior cancelada para gerar 2ª via do Boleto com multa e juros - API Gerencianet</p>';
                    print_r($cancelCharge);
					echo '<br/>';
					//echo $cancelCharge['code'];
                    echo '</pre>';
                }
            } catch (GerencianetException $e) {
				$error	= '<p class="erro">Erro ao cancelar Boleto anterior: ' . $e->errorDescription . '</p>';
                if ($DEBUG) {
                    echo '<pre class="debug"><p class="erro">Erro ao cancelar transação - API Gerencianet</p>';
                    echo '<br/>';
                    print_r($e->errorDescription);
                    echo '<br/></pre>';
                }
            } catch (Exception $e) {
				$error	= '<p class="erro">Erro ao cancelar Boleto anterior: ' . $e->getMessage() . '</p>';
                if ($DEBUG) {
                    echo '<pre class="debug"><p class="erro">Erro 2 ao cancelar transação - API Gerencianet</p>';
                    print_r($e->getMessage());
                    echo '<br/></pre>';
                }
            }
	if ( !$error ) {
		return (string)'sucess';
	} elseif ($error) {
		return $error;
	}
}

/**
 *
 * Atualizar vencimento do Boleto
 * ggnb_update_billet
 *
 */

function ggnb_update_billet( $API, $CHARGEEXISTID, $BILLETDUEDATE, $DEBUG ) {
	try {
		$updateBillet = $API->updateBillet(['id' => (int)$CHARGEEXISTID], ['expire_at' => $BILLETDUEDATE]);

                if ($DEBUG) {
					echo '<pre class="debug"><p class="ok">Data de vencimento do boleto atualizada - API Gerencianet.</p>';
					print_r($updateBillet);
					echo '</pre>';
				}
			} catch (GerencianetException $e) {
				$error = '<b>Não foi possível atualizar a data de venvimento desse Boleto, por favor <a href="'.$systemUrl.'/submitticket.php" target="_blank">entre em contato</a> informando o ID da fatura e o código do erro.<br/>Erro: '.$e->code.' - '.$e->errorDescription.'</b>';
				
				if ($DEBUG) {
					echo '<pre class="debug"><p class="erro">Erro ao atualizar o vencimento do Boleto - API Gerencianet.</p>';
					print_r($e->errorDescription);
					echo '<br/></pre>';
				}
			} catch (Exception $e) {
				$error = '<b>Não foi possível atualizar a data de venvimento desse Boleto, por favor <a href="'.$systemUrl.'/submitticket.php" target="_blank">entre em contato</a> informando o ID da fatura e erro:<br/>'.$e->getMessage().'</b>';
				if ($DEBUG) {
					echo '<pre class="debug"><p class="erro">Erro ao atualizar o vencimento do Boleto - API Gerencianet.</p>';
					print_r($e->getMessage());
					echo '<br/></pre>';
				}
			}
	if ( $updateBillet ) {
		return 'sucess';
	} else {
		return $error;
	}
}
/**
 *
 * Criar transação
 * @ggnb_create_charge
 *
 */
 function ggnb_create_charge( $API, $BODY, $DEBUG) {
	// Gerar transação
				try {
					$charge = $API->createCharge([], $BODY);
					$chargeID = $charge['data']['charge_id'];
					//$chargeCID = $charge['data']['custom_id'];
					
					if ($DEBUG) {
						echo'<pre class="debug"><p class="ok">Nova transação gerada com sucesso - API Gerencianet.</p>'; 
						print_r($charge);
						echo 'charge id: ' .$chargeID;
						echo'<br/></pre>'; 
					}
				// Erros
				} catch ( GerencianetException $e) {
					$error = '<b>Não foi possível gerar o boleto, por favor <a href="'.$systemUrl.'/submitticket.php" target="_blank">entre em contato</a> informando o ID da fatura e o código do erro.<br/>Erro: '.$e->code.' - '.$e->errorDescription.'</b>';
					if ($DEBUG) {
						echo'<pre class="debug"><p class="erro">Falha ao gerar a transação - API Gerencianet.</p>';
						print_r($e->code);
						print_r($e->error);
						print_r($e->errorDescription);
						echo '<br/></pre>';
					}
 				} catch (Exception $e) {
					$error = '<b>Não foi possível gerar o boleto, por favor <a href="'.$systemUrl.'/submitticket.php" target="_blank">entre em contato</a> informando o ID da fatura e o erro.<br/>'.$e->getMessage().'</b>';
					if ($DEBUG) {
						echo'<pre class="debug"><p class="erro">Falha ao gerar a transação - API Gerencianet.</p>';
						print_r($e->getMessage());
						echo '<br/></pre>';
					}
				} 
				
			if ($chargeID) {
				return $chargeID;
			}
			else {
				return $error;
			}
 }
 
/**
 *
 * Criar Cobrança
 * @ggnb_pay_charge
 *
 */
function ggnb_pay_charge( $API, $CHARGEID, $BODY2, $DEBUG) {

	// Erros comuns
	$CPF_ERROR = '<b><span class="ggnberror">Erro ao gerar o Boleto:<br/>CPF incorreto.<br/><a href="'.$systemUrl.'/clientarea.php?action=details" target="_blank" title="Minha Conta">Atualize aqui seu CPF</a>.</span></b>';

	$CNPJ_ERROR = '<b><span class="ggnberror">Erro ao gerar o Boleto:<br/>CNPJ incorreto.<br/><a href="'.$systemUrl.'/clientarea.php?action=details" target="_blank" title="Minha Conta">Atualize aqui seu CNPJ</a>.</span></b>';

	$PHONENUMBER_ERROR = '<b><span class="ggnberror">Erro ao gerar o Boleto:<br/>Telefone incorreto.<br/><a href="'.$systemUrl.'/clientarea.php?action=details" target="_blank" title="Minha Conta">Atualize aqui seu Telefone</a>.</span></b>';

	$NAME_ERROR = '<b><span class="ggnberror">Erro ao gerar o Boleto:<br/>Nome e/ou Sobrenome incorretos.<br/><a href="'.$systemUrl.'/clientarea.php?action=details" target="_blank" title="Minha Conta">Atualize aqui seu Nome/Sobrenome</a>.</span></b>';

	$PROFILE_ERROR = '<b><span class="ggnberror">Erro ao gerar o Boleto devido a inconsistências no seu cadastro.<br/><a href="'.$systemUrl.'/clientarea.php?action=details" target="_blank" title="Minha Conta">Atualize aqui seu cadastro</a>.</span></b>';
	 
	 // executa pagamento
	 try {
		
		$params2 = ['id' => (int)$CHARGEID];
		$chargePay = $API->payCharge($params2, $BODY2);
		
		if ($DEBUG) {
			echo'<pre class="debug"><p class="ok">Boleto gerado com sucesso - API Gerencianet.</p>';
			print_r($chargePay);
			echo'<br/>$params2 & $BODY2:<br/>';
			print_r($params2);
			echo'<br/>';
			print_r($BODY2);
			echo'<br/></pre>';
		}
	// Erros
	} catch (GerencianetException $e) {
		
		$error = '<b><span class="ggnberror">Erro ao gerar o Boleto:<br/>'.$e->errorDescription.'<br/><a href="'.$systemUrl.'/submitticket.php" target="_blank">Contate o suporte</a> informando o ID da fatura.';
	
		if ($DEBUG) {
			echo'<pre class="debug"><p class="erro">Falha ao gerar o boleto - 1ª tentativa - API Gerencianet.</p>';
			print_r($e);
			echo'<br/></pre>';
		}

	} catch (Exception $e) {
		
		// Erro "CPF incorreto"
		if( strpos($e->getMessage(), 'cpf') !== false || strpos($e->getMessage(), 'Cpf') !== false ) {
			$chargePayError = $CPF_ERROR;
		}
		// Erro "CNPJ incorreto" - Não Exibir erro
		elseif( strpos($e->getMessage(), 'cnpj') !== false  || strpos($e->getMessage(), 'Cnpj') !== false ) {
			$chargePayError = false;
			$chargePayErrorTryCPF = true;
		}
		// Erro "Telefone incorreto"
		elseif( strpos($e->getMessage(), 'phone_number') !== false) {
			$chargePayError = $PHONENUMBER_ERROR;
		}
		// Erro "Nome incorreto"
		elseif( strpos($e->getMessage(), 'name') !== false) {
			$chargePayError = $NAME_ERROR;
		}
		// Erro no cadastro
		elseif( strpos($e->getMessage(), 'customer') !== false) {
			$chargePayError = $PROFILE_ERROR;
		}
		// Outros erros 
		else {

			$chargePayError = '<b><span class="ggnberror">Erro ao gerar o Boleto:<br/>'.$e->getMessage().'<br/><a href="'.$systemUrl.'/submitticket.php" target="_blank">Contate o suporte</a> informando o ID da fatura.';
		}
		
		$error = $chargePayError;
		
		if ($DEBUG) {
			echo'<pre class="debug"><p class="erro">Falha ao gerar o boleto - 1ª tentativa, - API Gerencianet.</p>';
			print_r($e->getMessage());
			echo'<br/>$params2 & $BODY2:<br/>';
			print_r($params2);
			echo'<br/>';
			print_r($BODY2);
			echo'<br/></pre>';
		}
	}
	
	// Tentar gerar cobrança novamente com CPF, em caso de CNPJ incorreto
	if ( $chargePayErrorTryCPF ) {

	 	try {
		
			$params2 = ['id' => (int)$CHARGEID];
			$chargePay = $API->payCharge($params2, $BODY2);
		
			if ($DEBUG) {
				echo'<pre class="debug"><p class="ok">Boleto gerado com sucesso - API Gerencianet.</p>';
				print_r($chargePay);
				echo'<br/></pre>';
			}
		// Erros
		} catch (GerencianetException $e) {

			$error = '<b><span class="ggnberror">Erro ao gerar o Boleto:<br/>'.$e->errorDescription.'<br/><a href="'.$systemUrl.'/submitticket.php" target="_blank">Contate o suporte</a> informando o ID da fatura.';
	
			if ($DEBUG) {
				echo'<pre class="debug"><p class="erro">Falha ao gerar o boleto - 2ª tentativa - API Gerencianet.</p>';
				print_r($e->code);
				print_r($e->error);
				print_r($e->errorDescription);
				echo'<br/></pre>';
			}
		
		} catch (Exception $e) {
			// Erro "CPF incorreto"
			if( strpos($e->getMessage(), 'cpf') !== false || strpos($e->getMessage(), 'Cpf') !== false ) {
				$chargePayError = $CPF_ERROR;
			}
			// Erro "CNPJ incorreto" - Não Exibir erro
			elseif( strpos($e->getMessage(), 'cnpj') !== false  || strpos($e->getMessage(), 'Cnpj') !== false ) {
				$chargePayError = false;
				$chargePayErrorTryCPF = true;
			}
			// Erro "Telefone incorreto"
			elseif( strpos($e->getMessage(), 'phone_number') !== false) {
				$chargePayError = $PHONENUMBER_ERROR;
			}
			// Erro "Nome incorreto"
			elseif( strpos($e->getMessage(), 'name') !== false) {
				$chargePayError = $NAME_ERROR;
			}
			// Erro no cadastro
			elseif( strpos($e->getMessage(), 'customer') !== false) {
				$chargePayError = $PROFILE_ERROR;
			}
			// Outros erros 
			else {

				$chargePayError = '<b><span class="ggnberror">Erro ao gerar o Boleto:<br/>'.$e->getMessage().'<br/><a href="'.$systemUrl.'/submitticket.php" target="_blank">Contate o suporte</a> informando o ID da fatura.';
			}
		
			$error = $chargePayError;
		
			if ($DEBUG) {
				echo'<pre class="debug"><p class="erro">Falha ao gerar o boleto - 1ª tentativa, - API Gerencianet.</p>';
				print_r($e->getMessage());
				echo'<br/></pre>';
			}
		}
	}
		
	if ( !$error ) {
		return $chargePay;
		
	} elseif ( $error ) {
		return (string)$error;
	}
}

/**
 *
 * Gravar transação no WHMCS
 * @ggnb_add_trans
 *
 */
function ggnb_add_trans( $USERID, $INVOICEID, $CHARGEID, $whmcsAdmin, $api_mode, $DEBUG ) {
	$addtransaction = "addtransaction";
 	$addtransvalues['userid'] = $USERID;
 	$addtransvalues['invoiceid'] = $INVOICEID;
 	$addtransvalues['description'] = "Boleto gerado aguardando pagamento.";
 	$addtransvalues['amountin'] = '0.00';
 	$addtransvalues['fees'] = '0.00';
 	$addtransvalues['paymentmethod'] = 'gofasgerencianetboleto';
 	$addtransvalues['transid'] = 'ggnb_'.$api_mode.'_waiting-'.$CHARGEID.'';
 	$addtransvalues['date'] = date('d/m/Y');
	$addtransresults = localAPI( $addtransaction, $addtransvalues, $whmcsAdmin );
	
		if ($DEBUG and $addtransresults['result'] === 'success') {
			echo'<pre class="debug"><p class="ok">Transação gravada com sucesso - API WHMCS.</p>';
			echo 'ID da Transação: ' . $addtransvalues['transid'] . '<br>';
			print_r($addtransresults);
			echo'<br/></pre>';
		} elseif ($DEBUG and $addtransresults['result'] !== 'success'){
			echo'<pre class="debug"><p class="erro">Erro ao gravar a transação - API WHMCS.</p>';
			print_r($addtransresults);
			echo'<br/></pre>';
		}
	if ( $addtransresults['result'] === 'success' ) {
		return $addtransresults;
		
	} elseif ($addtransresults['result'] !== 'success') {
		$error = '<b>Não foi possível gerar o boleto, por favor <a href="'.$systemUrl.'/submitticket.php" target="_blank">entre em contato</a> informando o ID da fatura.</b>';
		return $error;
	}
}
/**
 *
 * Envia email ao admin em caso de erro
 * ggnb_send_error_email
 *
 */
 
function ggnb_send_error_email( $INVOICEID, $USERID, $FNAME, $LNAME, $SYSTEMURL, $ADMIN, $EOE, $ERROR, $DEBUG ) {
	$sendEmailonError = "sendadminemail";
 	$sendEOEvalues['customsubject'] = 'Erro ao gerar boleto - fatura #'.$INVOICEID;
	$sendEOEvalues['custommessage'] = '<br/>Olá administrador,<br/>
		Ocorreu uma falha ao gerar um Boleto para a <a href="'.$SYSTEMURL.'/admin/invoices.php?action=edit&id='.$INVOICEID.'">Fatura #'.$INVOICEID.'</a>.<br/><br/>
		Detalhes do erro:<br/>
		<b>Cliente:</b> <a href="'.$SYSTEMURL.'/admin/clientssummary.php?userid='.$USERID.'">'.$FNAME.' '.$LNAME.'</a><br/><br/>
		<b>Erro exibido na Fatura:</b><br/><i>"'.$ERROR.'"</i><br/><br/>
		Email gerado de acordo com às configurações do gateway <a title="Ir para as configurações do módulo ↗" href="'.$SYSTEMURL.'/admin/configgateways.php?updated=gofasgerencianetboleto#m_gofasgerencianetboleto">Gofas Gerencianet Boleto</a>.<br/><br/>';
 	$sendEOEvalues['type'] = 'system';
 	$sendEOEvalues['deptid'] = $EOE;
 	$sendEOEresults = @localAPI($sendEmailonError,$sendEOEvalues,$ADMIN);
		
	if ($DEBUG and $sendEOEresults['result'] === 'success'){
		echo'<pre class="debug"><p class="ok">Email envido ao admin notificando o erro - API WHMCS.</p>';
		print_r($sendEOEresults);
		echo'<br/></pre>';
	} elseif($DEBUG and $sendEOEresults['result'] !== 'success') {
		echo'<pre class="debug"><p class="error">Falha ao enviar email notificando o erro - API WHMCS.</p>';
		print_r($sendEOEresults);
		echo'<br/></pre>';
	}
	return $sendEOEresults;
 }