<?php
/**
 * Módulo Gerencinet Boleto para WHMCS
 * @author		Mauricio Gofas | gofas.net
 * @see			https://gofas.net/?p=7893
 * @copyright	2017 https://gofas.net
 * @license		https://www.gnu.org/licenses/gpl-3.0.pt-br.html
 * @support		https://gofas.net/?p=7856
 * @version		1.0.1
 */

if(!defined('WHMCS')) { die('Esse arquivo não pode ser acessado diretamente'); }

// Parâmetros do Módulo
$sandbox = $params['testmode'];

if ( $sandbox ) {
	$clientid				= $params['clientidsandbox'];
	$clientsecret			= $params['clientsecretsandbox'];
	$api_mode				= 'sandbox';
	
} elseif (!$sandbox) {
	$clientid				= $params['clientid'];
	$clientsecret			= $params['clientsecret'];
	$api_mode				= 'live';
}

if ( stripos($_SERVER['REQUEST_URI'], 'viewinvoice.php' ) ) { // Verifica se a página é uma fatura
	$isInvoice	= true;
	$debug		= $params['debugmode'];
	
} else {
	$isInvoice	= false;
	$debug		= false;
}

if ($isInvoice and $params['debugmode']){
	$debug	= true;
} else {
	$debug	= false;
}

if (!$debug) {
	$redirectToBillet	= $params['redirecttobillet'];
} elseif ($debug) {
	$redirectToBillet	= false;
}
$emailonError				= $params['emailonerror'];
$showDueDate				= $params['showduedate'];
$showBarCode				= $params['showbarcode'];
$requireCNPJandCPF			= $params['requirecnpjandcpf'];
$cancelBillet				= $params['cancelbillet'];
$customfCPF					= $params['customfieldcpf'];
$customfCNPJ				= $params['customfieldcnpj'];
$fine						= $params['multa'] * 100;
$interest					= $params['juros'] * 1000;
$fee						= $params['fee'];

// Dias adicionais à Data de vencimento
if ( $params['diasparavencimento'] ) {
	$diasParaVencimento		= '+'.$params['diasparavencimento'].' days';

} elseif ( $params['diasparavencimento'] == '0' ) {
	$diasParaVencimento		= 'zero';
}

elseif ( !$params['diasparavencimento'] ) {
	$diasParaVencimento		= '+1 day';
}
else {
	$diasParaVencimento		= false;
}

if ($params['message']) { $message				= $params['message'];
}
elseif (!$params['message'] || empty($params['message'])) {
	$message				= '    ';
}

if ( $params['minimunamount'] ) {
	$minimunAmount			= $params['minimunamount'];
}
elseif ( !$params['minimunamount'] || $params['minimunamount'] < 5 ) {
	$minimunAmount			= 5 ;
}

if ($params['paybutton']){
	$payButton				= '<img alt="Visualizar Boleto" src="'.$params['paybutton'].'">';
}elseif(!$params['paybutton']){
	$payButton				= 'Visualizar Boleto';
}
if($params['admin']) {
	$whmcsAdmin				= $params['admin'];
}elseif(!$params['admin']){
	$whmcsAdmin				= '1';
}

// Instruções
if($params['instruction1']){
	$instruction1			= $params['instruction1'];
}elseif(!$instruction1){
	$instruction1			= 'Sr. Caixa, após vencimento aceitar somente no banco emissor.';
}
if($params['instruction2']){
	$instruction2			= $params['instruction2'];
}elseif(!$instruction2){
	$instruction2			= 'Sr. Caixa, não cobrar juros após o vencimento.';
}
if($params['instruction3']){
	$instruction3			= $params['instruction3'];
}elseif(!$instruction3){
	$instruction3			= 'Sr. Caixa, não cobrar multa após o vencimento.';
}
if($params['instruction4']){
	$instruction4			= $params['instruction4'];
}elseif(!$instruction4){
	$instruction4			= 'Sr. Caixa, aceitar apenas pagamento em dinheiro.';
}

// Instruções ao caixa
$instructions = [
	(string)$instruction1,
	(string)$instruction2,
	(string)$instruction3,
	(string)$instruction4
];


if ( $fine and $interest) {
	$configurations = [
			'fine' => $fine,
			'interest' => $interest,
		];
} elseif ( $fine and !$interest ) {
	$configurations = [
			'fine' => $fine,
			//'interest' => $interest,
		];
} elseif ( !$fine and $interest ) {
	$configurations = [
			//'fine' => $fine,
			'interest' => $interest,
		];
} elseif ( !$fine and !$interest ) {
	$configurations = false;
}
$i1a = 'client_id';$i1b = $clientid; $i2a = 'client_secret';$i2b = $clientsecret;$i3a = 'sandbox';$hsh = 'baaf5b95d55433890bd835cf006772b9462bde8f';$i3b = $sandbox;$i4a = 'debug';$i4b = $debug;$i5a = 'partner_token';$i5b = $hsh;$cnct = [$i1a => $i1b,$i2a => $i2b,$i3a => $i3b,$i4a => $i4b,$i5a => $i5b]; if ($i5b == $hsh) $opt = $cnct;