<?php
/**
 * Módulo Gerencinet Boleto para WHMCS
 * @author		Mauricio Gofas | gofas.net
 * @see			https://gofas.net/?p=7893
 * @copyright	2017 https://gofas.net
 * @license		https://www.gnu.org/licenses/gpl-3.0.pt-br.html
 * @support		https://gofas.net/?p=7856
 * @version		1.0.1
 */

if(!defined('WHMCS')) { die('Esse arquivo não pode ser acessado diretamente'); }

// Parametros do Cliente
$userID						= $params['clientdetails']['id'];
$firstname					= $params['clientdetails']['firstname'];
$lastname					= $params['clientdetails']['lastname'];
$phone						= preg_replace('/[^0-9]/', '', $params['clientdetails']['phonenumber']);

if ( $params['clientdetails']['companyname'] ) {
	$corporateName			= $params['clientdetails']['companyname'];
} elseif (!$params['clientdetails']['companyname']) {
	$corporateName			= $firstname . ' ' . $lastname;
}

$cpf_customfield_value = preg_replace("/[^0-9]/", "", $params["clientdetails"]["customfields"]["$customfCPF"]["value"]);
$cnpj_customfield_value = preg_replace("/[^0-9]/", "", $params["clientdetails"]["customfields"]["$customfCNPJ"]["value"]);

if (strlen($cpf_customfield_value) === 10) {
	$cpf = '0'.$cpf_customfield_value;
	
	if (strlen($cnpj_customfield_value) === 13) {
		
		$cnpj = '0'.$cnpj_customfield_value;
		$juridical_data = [
  			'corporate_name' => $corporateName,
  			'cnpj' => $cnpj
		];
		
		if ( $requireCNPJandCPF ) {
			$customer = [
				'name' => $firstname.' '.$lastname,
				'cpf' => $cpf,
				'phone_number' => $phone,
				'juridical_person' => $juridical_data
			];
		} elseif ( !$requireCNPJandCPF ) {
			$customer = [
				'phone_number' => $phone,
				'juridical_person' => $juridical_data
			];
		}
		
	} elseif (strlen($cnpj_customfield_value) === 14) {
		$cnpj = $cnpj_customfield_value;
		$juridical_data = [
  			'corporate_name' => $corporateName,
  			'cnpj' => $cnpj
		];
		
		if ( $requireCNPJandCPF ) {
			$customer = [
				'name' => $firstname.' '.$lastname,
				'cpf' => $cpf,
				'phone_number' => $phone,
				'juridical_person' => $juridical_data
			];
		} elseif ( !$requireCNPJandCPF ) {
			$customer = [
				'phone_number' => $phone,
				'juridical_person' => $juridical_data
			];
		}
		
	} elseif ( !$cnpj_customfield_value || strlen($cnpj_customfield_value) !== 14 || strlen($cnpj_customfield_value) !== 13) {
		$cnpj = false;		
		$customer = [
			'name' => $firstname.' '.$lastname,
			'cpf' => $cpf,
			'phone_number' => $phone,
		];

	}
}
elseif (strlen($cpf_customfield_value) === 11) {
	$cpf = $cpf_customfield_value;
	
	if (strlen($cnpj_customfield_value) === 13) {
		$cnpj = '0'.$cnpj_customfield_value;
		$juridical_data = [
  			'corporate_name' => $corporateName,
  			'cnpj' => $cnpj
		];
		
		if ( $requireCNPJandCPF ) {
			$customer = [
				'name' => $firstname.' '.$lastname,
				'cpf' => $cpf,
				'phone_number' => $phone,
				'juridical_person' => $juridical_data
			];
		} elseif ( !$requireCNPJandCPF ) {
			$customer = [
				'phone_number' => $phone,
				'juridical_person' => $juridical_data
			];
		}
		
	} elseif (strlen($cnpj_customfield_value) === 14) {
		$cnpj = $cnpj_customfield_value;
		$juridical_data = [
  			'corporate_name' => $corporateName,
  			'cnpj' => $cnpj
		];
		
		if ( $requireCNPJandCPF ) {
			$customer = [
				'name' => $firstname.' '.$lastname,
				'cpf' => $cpf,
				'phone_number' => $phone,
				'juridical_person' => $juridical_data
			];
		} elseif ( !$requireCNPJandCPF ) {
			$customer = [
				'phone_number' => $phone,
				'juridical_person' => $juridical_data
			];
		}
		
	} elseif ( !$cnpj_customfield_value || strlen($cnpj_customfield_value) !== 14 || strlen($cnpj_customfield_value) !== 13) {
		$cnpj = false;
		$customer = [
			'name' => $firstname.' '.$lastname,
			'cpf' => $cpf,
			'phone_number' => $phone,
		];
	}
}
elseif (strlen($cpf_customfield_value) === 13) {
	$cpf = false; 
	$cnpj = '0'.$cpf_customfield_value;
	$juridical_data = [
  			'corporate_name' => $corporateName,
  			'cnpj' => $cnpj
		];
		
	if ( $requireCNPJandCPF ) {
			$customer = [
				'name' => $firstname.' '.$lastname,
				'cpf' => $cpf,
				'phone_number' => $phone,
				'juridical_person' => $juridical_data
			];
	} elseif ( !$requireCNPJandCPF ) {
		$customer = [
			'phone_number' => $phone,
			'juridical_person' => $juridical_data
		];
	}
	
}
elseif (strlen($cpf_customfield_value) === 14) {
	$cpf 				= false;
	$cnpj				= $cpf_customfield_value;
	$juridical_data = [
  			'corporate_name' => $corporateName,
  			'cnpj' => $cnpj
		];
		
	if ( $requireCNPJandCPF ) {
			$customer = [
				'name' => $firstname.' '.$lastname,
				'cpf' => $cpf,
				'phone_number' => $phone,
				'juridical_person' => $juridical_data
			];
	} elseif ( !$requireCNPJandCPF ) {
		$customer = [
			'phone_number' => $phone,
			'juridical_person' => $juridical_data
		];
	}

}

elseif (!$cpf_customfield_value || strlen($cpf_customfield_value) !== 10 || strlen($cpf_customfield_value) !== 11 || strlen($cpf_customfield_value) !== 13 || strlen($cpf_customfield_value) !== 14 ) {
	if (strlen($cnpj_customfield_value) === 13) {
		
		$cnpj = '0'.$cnpj_customfield_value;
		$juridical_data = [
  			'corporate_name' => $corporateName,
  			'cnpj' => $cnpj
		];
		if ( $requireCNPJandCPF ) {
			$customer = [
				'name' => $firstname.' '.$lastname,
				'cpf' => $cpf,
				'phone_number' => $phone,
				'juridical_person' => $juridical_data
			];
		} elseif ( !$requireCNPJandCPF ) {
			$customer = [
				'name' => $firstname.' '.$lastname,
				'phone_number' => $phone,
				'juridical_person' => $juridical_data
			];
		}
	} elseif (strlen($cnpj_customfield_value) === 14) {
		$cnpj = $cnpj_customfield_value;
		$juridical_data = [
  			'corporate_name' => $corporateName,
  			'cnpj' => $cnpj
		];
		
		if ( $requireCNPJandCPF ) {
			$customer = [
				'name' => $firstname.' '.$lastname,
				'cpf' => $cpf,
				'phone_number' => $phone,
				'juridical_person' => $juridical_data
			];
		} elseif ( !$requireCNPJandCPF ) {
			$customer = [
				'phone_number' => $phone,
				'juridical_person' => $juridical_data
			];
		}
		
	} elseif ( !$cnpj_customfield_value || strlen($cnpj_customfield_value) !== 14 || strlen($cnpj_customfield_value) !== 13) {
		$cnpj = false;
		$cpf = false;
	}
}
// Dados pessoa física
$customer_pf = [
	'name' => $firstname.' '.$lastname,
	'cpf' => $cpf,
	'phone_number' => $phone,
];