<?php
/**
 * Módulo Gerencinet Boleto para WHMCS
 * @author		Mauricio Gofas | gofas.net
 * @see			https://gofas.net/?p=7893
 * @copyright	2017 https://gofas.net
 * @license		https://www.gnu.org/licenses/gpl-3.0.pt-br.html
 * @support		https://gofas.net/?p=7856
 * @version		1.1.0
 */

if(!defined('WHMCS')) { die('Esse arquivo não pode ser acessado diretamente'); }

/*
 *
 * Desconto / Taxa
 *
*/

$customFieldDescontoTipo	= $params['customfielddescontotipo']; // ID do campo
$customFieldDescontoValor	= $params['customfielddescontovalor']; // ID do campo
$custom_discount_type		= $params["clientdetails"]["customfields"]["$customFieldDescontoTipo"]["value"];
$custom_discount_value		= $params["clientdetails"]["customfields"]["$customFieldDescontoValor"]["value"];

// Define desconto personalizado 
if ( $custom_discount_value and $custom_discount_type ) {
	$discount_tax			= 1;
	$discount_tax_value		= $custom_discount_value;
	
	if ( strpos( $custom_discount_type, '%' ) !== false ) {
		$discount_tax_type		= 1;
	}
	
	if ( strpos( $custom_discount_type, '$' ) !== false ) {
		$discount_tax_type		= 2;
	}
}
else {
	$discount_tax				= (int)$params['descontooutaxa']; // Define se é desconto ou taxa: 1 = desconto | 2 = taxa
	$discount_tax_type			= (int)$params['tipodescontooutaxa']; // 1 = % | 2 = $  
	$discount_tax_value 		= $params['valordescontooutaxa'];
}

// Validade do desconto
$days_for_discount			= (int)$params['diasantesvencadddesconto']; // $invoiceDuedate - $days_for_discount

if ( $days_for_discount >= 1 ) {
	
	$limit_date = new DateTime( $invoiceDuedate );
	$limit_date->sub(new DateInterval("P".$days_for_discount."D"));
	$discount_valid_until = $limit_date->format('Y-m-d');
	
	//unset($configurations);
	//$instructions = [ (string)'Sr. Caixa, por favor: Não aceitar pagamento após o vencimento.', (string)' ', (string)' ', (string)' ', ];

}
if ( $days_for_discount === 0 ) {
	
	$discount_valid_until = $invoiceDuedate;
	
	//unset($configurations);
	//$instructions = [ (string)'Sr. Caixa, por favor: Não aceitar pagamento após o vencimento.', (string)' ', (string)' ', (string)' ', ];
}

// Define data de validade do desconto
if ( $discount_tax === 1 and $discount_valid_until and $discount_valid_until < date( 'Y-m-d' ) ) {
	$discount_tax_value = 0;
}
if ( $discount_tax === 1 and $discount_valid_until and $discount_valid_until >= date( 'Y-m-d' ) ) {
		
		unset($configurations);
		$billetDuedate = $discount_valid_until;
		
		// Instruções ao caixa
		$instructions = [
			(string)'Sr. Caixa, por favor: Não aceitar pagamento após o vencimento.',
			(string)' ',
			(string)' ',
			(string)' ',
		];
}

// Exibir info sobre desconto na fatura
$discount_tax_visible		= $params['exibedescontooutaxa'];

// Desconto do WHMCS / Itens com valor negativo
$disc_item = array();
foreach( $invoiceItemsItem as $Key => $Value){
		
		if ($Value['amount'] < 0 ) {
			$n_item = (string)$Value['amount'] * 100;
			$ngtv_item = preg_replace('/[^0-9]/', '', $n_item);
			$negative_item = (int)$ngtv_item;
			$disc_item[] = $negative_item; // Array com itens negativos
			
			$discount_item = (int)array_sum( $disc_item );
		}
}
if ( $invoiceCredit > 0 and $discount_item > 0 ) {
	$whmcs_discount = $invoiceCredit + $discount_item;
}
elseif ( $invoiceCredit > 0 and !$discount_item ) {
	$whmcs_discount = $invoiceCredit;
}
elseif ( !$invoiceCredit and $discount_item > 0 ) {
	$whmcs_discount = $discount_item;
}


// Cálculo de multa e juros
function ggnb_calculate_fine_interest( $VALUE, $fine, $interest, $invoiceDuedate, $debug ) {

	$today = date('Y-m-d');
	$due_date = date('Y-m-d', strtotime($invoiceDuedate));
	$datetime1 = new DateTime( $today );
	$datetime2 = new DateTime( $due_date );
	$interval = $datetime1->diff( $datetime2 );
	$due_days = $interval->format('%d');

	if ( $fine and $invoiceDuedate >= date('Y-m-d') ) {
		$fine_value = false;
	}
	elseif ( $fine and $invoiceDuedate < date('Y-m-d')) {
		$fine_value = ( ( $fine / 100 ) * $VALUE );
		
	}
	if ( $interest and $invoiceDuedate >= date('Y-m-d') ) {
		$interest_value = false;
	}
	elseif ( $interest and $invoiceDuedate < date('Y-m-d') ) {
		$interest_value = ( ($due_days * $interest) / 1000 ) * $VALUE;
	}
	
	if ( $fine and $interest ) {
		$new_value = ($VALUE * 100) + ($fine_value + $interest_value);
		
		return (int)$new_value;
	}
	elseif ( $fine and !$interest) {
		$new_value = ($VALUE * 100) + $fine_value;
		return (int)$new_value;
	}
	elseif ( !$fine and $interest) {
		$new_value = ($VALUE * 100) + $interest_value;
		return (int)$new_value;
	}
	elseif ( !$fine and !$interest) {
		$new_value = $VALUE * 100;
		return (int)$new_value;
	}
}

// Desconto em porcentagem %
if ( $discount_tax === 1 and $discount_tax_type === 1 and $discount_tax_value ) {
	$discount_tax_valueRS		= ( $discount_tax_value / 100 ) * $invoiceTotal;
	$invoiceAmount 				= ( $invoiceTotal - $discount_tax_valueRS ) * 100;
	$discount_tax_visible_message	= '<p class="ggnbp">Desconto de '.$discount_tax_value.'% para pagamento com Boleto! Total: R$'.$invoiceAmount / 100 . '</p>';

	$item = array();
	foreach( $invoiceItemsItem as $itemKey => $itemValue) {
		
		if ($itemValue['amount'] >= 0 ) {
			$item[] = ['name' => substr($itemValue['description'], 0, 255 ), 'amount' => 1, 
			'value' => ggnb_calculate_fine_interest( $itemValue['amount'], $fine, $interest, $invoiceDuedate, $debug) ];
		}
	}
	
	$items = $item;
	
	$discount_value	= (int)($discount_tax_value * 100);
	
	if ($whmcs_discount > 0 ) {
		$discount = [
		
			'type' => 'currency',
			'value' => (int)( ($discount_tax_valueRS * 100) + $whmcs_discount),
		
		];
		
	}
	else {
		$discount = [
		
			'type' => 'percentage',
			'value' => $discount_value,
		
		];
	}

}
// Desconto Fixo R$
elseif ( $discount_tax === 1 and $discount_tax_type === 2 and $discount_tax_value ) {
	$invoiceAmount 			= ( $invoiceTotal - $discount_tax_value ) * 100;
	$discount_tax_visible_message	= '<p class="ggnbp">Desconto de R$'.$discount_tax_value.' para pagamento com Boleto! Total: R$'.$invoiceAmount / 100 .'</p>';

	$item = array();
	foreach( $invoiceItemsItem as $itemKey => $itemValue ){
		if ($itemValue['amount'] >= 0 ) {
			$item[] = ['name' => substr($itemValue['description'], 0, 255 ), 'amount' => 1, 
			'value' => ggnb_calculate_fine_interest( $itemValue['amount'], $fine, $interest, $invoiceDuedate, $debug) ];
		}
	}

	$items = $item;
	$discount_value	= (int)($discount_tax_value * 100);
	
	if ($whmcs_discount > 0 ) {
		$discount = [
		
			'type' => 'currency',
			'value' => $discount_value + $whmcs_discount,
		
		];
		
	}
	else {
		$discount = [
		
			'type' => 'currency',
			'value' => $discount_value,
		
		];
	}
	
}
// Taxa em porcentagem %
elseif ( $discount_tax === 2 and $discount_tax_type === 1 and $discount_tax_value ) {
	$discount_tax_valueRS	= ( $discount_tax_value / 100 ) * $invoiceTotal;
	$invoiceAmount 			= ( $invoiceTotal + $discount_tax_valueRS ) * 100;
	$discount_tax_visible_message	= '<p class="ggnbp">Taxa de '.$discount_tax_value.'% para emissão de Boleto. Total: R$'.$invoiceAmount / 100 . '</p>';
	echo '$discount_tax_visible_message: ',$discount_tax_visible_message;
	function calcule_amount( $price, $discount_tax ) {
		return $price + ( ( $discount_tax / 100 ) * $price ) ;
	}
	
	$item = array();
	foreach( $invoiceItemsItem as $itemKey => $itemValue){
		if ($itemValue['amount'] >= 0 ) {
			$item[] = ['name' => substr($itemValue['description'], 0, 255 ), 'amount' => 1, 
			'value' => ggnb_calculate_fine_interest( calcule_amount( $itemValue['amount'], $discount_tax_value ), $fine, $interest, $invoiceDuedate, $debug ) ];
		}
	}
	$items = $item;
	
	echo 'taxa %<br>'; // Debug
	print_r($items); // Debug
	
	if ($whmcs_discount > 0 ) {
		$discount = [
		
			'type' => 'currency',
			'value' => (int)$whmcs_discount,
		
		];
	}
}

// Taxa Fixa R$
elseif ( $discount_tax === 2 and $discount_tax_type === 2 and $discount_tax_value ) {
	$invoiceAmount 				= $invoiceTotal + $discount_tax_value;
	$discount_tax_visible_message	= '<p class="ggnbp">Taxa de R$'.$discount_tax_value.' para emissão de Boleto. Total: R$' .$invoiceAmount. '</p>';
	//$taxaFixa = true;
	
	$invoiceDescription	= $params['description'];
	$items = [
		[
			'name' => substr($invoiceDescription, 0, 255 ),
			'amount' => 1,
			'value' => ggnb_calculate_fine_interest( $invoiceAmount, $fine, $interest, $invoiceDuedate, $debug ),
		],
	];
	
	if ($whmcs_discount > 0 ) {
		$discount = [
		
			'type' => 'currency',
			'value' => (int)$whmcs_discount,
		
		];
		
	}
	
}
// Valor sem acréscimos ou descontos
elseif ( !$discount_tax_value ) {
	$item = array();
	foreach( $invoiceItemsItem as $itemKey => $itemValue){
		if ($itemValue['amount'] >= 0 ) {
			$item[] = ['name' => substr($itemValue['description'], 0, 255 ), 'amount' => 1, 
			'value' =>  ggnb_calculate_fine_interest( $itemValue['amount'],$fine, $interest,$invoiceDuedate, $debug) ];
		}
	}
	$items = $item;
	$invoiceAmount = $invoiceTotal * 100;
	
	if ($whmcs_discount > 0 ) {
		$discount = [
		
			'type' => 'currency',
			'value' => (int)$whmcs_discount,
		
		];
		
	}
}